* TrapRCBD_clerids.sas;
options pageno=1 linesize=80;
goptions reset=all;
title "Randomized block ANOVA for trapping experiment data";
data trapexp;
	input block $ treat $ count;
	* Apply transformations here;
	sqrtcount = sqrt(count);
	logcount = log(count+1);
	* Choose which variable is used for plots and anova;
	y = logcount;
	* Delete blank traps;
	if treat="BLANK" then delete;
	datalines;
1	AP		4
1	BLANK	0
1	FRAP	79
1	IDAP	7
1	ISAP	10
2	AP		1
2	BLANK	0
2	FRAP	124
2	IDAP	13
2	ISAP	20
3	AP		0
3	BLANK	0
3	FRAP	14
3	IDAP	.
3	ISAP	2
4	AP		0
4	BLANK	0
4	FRAP	15
4	IDAP	11
4	ISAP	7
5	AP		0
5	BLANK	0
5	FRAP	29
5	IDAP	7
5	ISAP	7
6	AP		2
6	BLANK	0
6	FRAP	70
6	IDAP	14
6	ISAP	20
;
run;
* Print data set;
proc print data=trapexp;
run;
* Plot means, standard errors, and observations;
proc gplot data=trapexp;
	plot y*treat=block / vaxis=axis1 haxis=axis1;
	symbol1 i=j v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
* Mixed model analysis;
proc mixed cl data=trapexp;
	class treat block;
	model y = treat / ddfm=kr outp=resids;
	random block;
	lsmeans treat / pdiff=all cl adjust=tukey adjdfe=row;
run;
goptions reset=all;
title "Diagnostic plots to check anova assumptions";
* Plot residuals vs. predicted values;
proc gplot data=resids;
	plot resid*pred=1 / vaxis=axis1 haxis=axis1;
	symbol1 v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
* Normal quantile plot of residuals;
proc univariate noprint data=resids;
	qqplot resid / normal waxis=3 height=4;
run;
quit;
